function x=RandStdNormT(zlow, zhigh)
%	RANDSTDNORM - x=RandStdNormT(zlow, zhigh)
PROBNLIMIT = 7;
if zlow>PROBNLIMIT & (isinf(zhigh) | zhigh>PROBNLIMIT)
   x = zlow + 100*eps;
elseif zhigh<-PROBNLIMIT & (isinf(zlow) | zlow<-PROBNLIMIT)
   x = zhigh - 100*eps;
else
	plow = normcdf(zlow);
   phigh = normcdf(zhigh);
   if plow==phigh
      disp('RandStdNormT. Error.');
      pause;
   end
   p = plow + rand(1)*(phigh-plow);
   switch p
	   case 1
   	   x = zlow + 100*eps;
	   case 0
   	   x = zlow - 100*eps;
	   otherwise
   	   x = norminv(p);
   end
   x = min(max(x,zlow),zhigh);
end
if ~isfinite(x)
   disp(['RandStdNormT returning non-finite x=' num2str(x)]);
   disp(sprintf('zlow=%25.15g\tzhigh=%25.15g',zlow,zhigh));
   disp(sprintf('plow=%25.15g\tphigh=%25.15g',plow,phigh));
   disp(sprintf('p=%25.15g',p));
   error('aborting');
end	